local assets =
{
	Asset("ANIM", "anim/qtree.zip"),
    Asset("ATLAS", "images/inventoryimages/tree.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("qtree")
    inst.AnimState:SetBuild("qtree")
    inst.AnimState:PlayAnimation("idle3")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
	inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "tree"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tree.xml"
    inst:AddComponent("selfstacker")
		local function OnDeploy (inst, pt)
    local tree = SpawnPrefab("tree")
	tree.Transform:SetPosition(pt.x, pt.y, pt.z)
	tree.components.pickable:OnTransplant()
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function onpickedfn(inst)
    inst:Remove()
end

local function treefn()
    local inst = CreateEntity()
	local birth = 0
local function ontransplantfn(inst)
    inst.components.pickable:MakeEmpty()
end
local function onregenfn(inst)
    inst.AnimState:PlayAnimation("idle", true)
end
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("qtree")
    inst.AnimState:SetBuild("qtree")
    inst.AnimState:PlayAnimation("idle4")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
	inst:AddComponent("tradable")
    inst:AddComponent("selfstacker")
	inst:AddComponent("pickable")
	inst.components.pickable:SetUp("log", TUNING.MARSHBUSH_REGROW_TIME*.25,20)
	inst.components.pickable.onregenfn = onregenfn
	inst.components.pickable.onpickedfn = onpickedfn
	inst.components.pickable.ontransplantfn = ontransplantfn
    MakeHauntableLaunchAndSmash(inst)


    return inst
end
return Prefab("treeseed", fn, assets),
Prefab("tree", treefn, assets),
MakePlacer("treeseed_placer", "qtree", "qtree", "idle4")